// $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/versclibs/data/rainier/X_RAMB36SDP_EXP.v,v 1.16 2008/01/04 01:15:11 wloo Exp $
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2005 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 8.1i (I.23)
//  \   \         Description : Xilinx Timing Simulation Library Component
//  /   /                  32K-Bit Data and 4K-Bit Parity Block RAM
// /___/   /\     Filename : X_RAMB36SDP_EXP.v
// \   \  /  \    Timestamp : Tues July 26 16:43:59 PST 2005
//  \___\/\___\
//
// Revision:
//    07/26/05 - Initial version.
//    12/07/06 - Fixed data output (CR 426370).
//    01/04/07 - Added support of memory file to initialize memory and parity (CR 431584).
//    03/14/07 - Removed attribute INITP_FILE (CR 436003).
//    04/03/07 - Changed INIT_FILE = "NONE" as default (CR 436812).
//    08/17/07 - Added setup/hold violation message on address w.r.t. clock (CR 436931).
//    01/03/08 - Fixed problem introduced by CR 436931 (CR 455893).
// End Revision

`timescale 1 ps/1 ps

module X_RAMB36SDP_EXP (DBITERR, DO, DOP, ECCPARITY, SBITERR, 
			DI, DIP, RDADDRL, RDADDRU, RDCLKL, RDCLKU, RDENL, RDENU, RDRCLKL, RDRCLKU, REGCEL, REGCEU, SSRL, SSRU, WEL, WEU, WRADDRL, WRADDRU, WRCLKL, WRCLKU, WRENL, WRENU );

    output DBITERR;
    output SBITERR;
    output [63:0] DO;
    output [7:0] DOP;
    output [7:0] ECCPARITY;

    input RDCLKL;
    input RDCLKU;
    input RDENL;
    input RDENU;
    input RDRCLKL;
    input RDRCLKU;
    input REGCEL;
    input REGCEU;
    input SSRL;
    input SSRU;
    input WRCLKL;
    input WRCLKU;
    input WRENL;
    input WRENU;
    input [14:0] RDADDRU;
    input [14:0] WRADDRU;
    input [15:0] RDADDRL;
    input [15:0] WRADDRL;
    input [63:0] DI;
    input [7:0] DIP;
    input [7:0] WEL;
    input [7:0] WEU;

    parameter integer DO_REG = 0;
    parameter EN_ECC_READ = "FALSE";
    parameter EN_ECC_SCRUB = "FALSE";
    parameter EN_ECC_WRITE = "FALSE";
    parameter INIT = 72'h0;
    parameter INITP_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_08 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_09 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INITP_0F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_02 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_03 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_04 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_05 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_06 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_07 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_08 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_09 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_0F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_10 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_11 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_12 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_13 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_14 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_15 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_16 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_17 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_18 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_19 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_1F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_20 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_21 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_22 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_23 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_24 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_25 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_26 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_27 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_28 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_29 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_2F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_30 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_31 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_32 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_33 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_34 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_35 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_36 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_37 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_38 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_39 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_3F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_40 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_41 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_42 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_43 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_44 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_45 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_46 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_47 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_48 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_49 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_4F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_50 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_51 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_52 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_53 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_54 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_55 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_56 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_57 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_58 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_59 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_5F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_60 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_61 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_62 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_63 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_64 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_65 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_66 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_67 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_68 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_69 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_6F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_70 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_71 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_72 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_73 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_74 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_75 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_76 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_77 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_78 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_79 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7A = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7B = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7C = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7D = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7E = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_7F = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_FILE = "NONE";
    parameter LOC = "UNPLACED";
    parameter SETUP_ALL = 1000;
    parameter SETUP_READ_FIRST = 3000;
    parameter SIM_COLLISION_CHECK = "ALL";
    parameter SRVAL = 72'h0;

    tri0 GSR = glbl.GSR;

    wire [7:0] wel_in, dangle_out8, eccparity_wire;
    wire dangle_out, dbiterr_wire, sbiterr_wire;
    wire [3:0] dangle_out4;
    wire [31:0] dangle_out32;
    wire [15:0] rdaddrl_in, wraddrl_in;
    wire [63:0] di_in, do_wire;
    wire [7:0]	dip_in, dop_wire;
    wire rdclkl_in, wrclkl_in, rdenl_in, wrenl_in;
    wire rdrclkl_in, regcel_in, ssrl_in;
    
    reg	notifier;
    reg notifier_addr0, notifier_addr1, notifier_addr2, notifier_addr3, notifier_addr4;
    reg notifier_addr5, notifier_addr6, notifier_addr7, notifier_addr8, notifier_addr9;
    reg notifier_addr10, notifier_addr11, notifier_addr12, notifier_addr13, notifier_addr14;
    reg notifier_addr15;
    
    reg [63:0] do_out;
    reg [7:0] dop_out, eccparity_out;
    reg dbiterr_out, sbiterr_out;
    
    buf b_rdaddrl[15:0] (rdaddrl_in, RDADDRL);
    buf b_wraddrl[15:0] (wraddrl_in, WRADDRL);
    buf b_rdclkl (rdclkl_in, RDCLKL);
    buf b_wrclkl (wrclkl_in, WRCLKL);
    buf b_rdrclkl (rdrclkl_in, RDRCLKL);
    
    buf b_di[63:0] (di_in, DI);
    buf b_dip[7:0] (dip_in, DIP);
    buf b_do[63:0] (DO, do_out);
    buf b_dop[7:0] (DOP, dop_out);

    buf b_rdenl (rdenl_in, RDENL);
    buf b_wrenl (wrenl_in, WRENL);
    buf b_regcel (regcel_in, REGCEL);
    buf b_ssrl (ssrl_in, SSRL);
    buf b_wel[7:0] (wel_in, WEL);
    buf b_sbiterr (SBITERR, sbiterr_out);
    buf b_dbiterr (DBITERR, dbiterr_out);
    buf b_eccparity[7:0] (ECCPARITY, eccparity_out);

    always @(do_wire or rdclkl_in) do_out = do_wire;
    always @(dop_wire or rdclkl_in) dop_out = dop_wire;
    always @(dbiterr_wire or rdclkl_in) dbiterr_out = dbiterr_wire;
    always @(sbiterr_wire or rdclkl_in) sbiterr_out = sbiterr_wire;
    always @(eccparity_wire or wrclkl_in) eccparity_out = eccparity_wire;
    
    localparam BRAM_MODE = (EN_ECC_WRITE == "TRUE" || EN_ECC_READ == "TRUE") ? "ECC" : "SIMPLE_DUAL_PORT";
    
    X_ARAMB36_INTERNAL INT_RAMB (.DIA(64'b0), .ENA(rdenl_in), .WEA(8'b0), .SSRA(ssrl_in), .ADDRA(rdaddrl_in), .CLKA(rdclkl_in), .DOA(do_wire), .DIB(di_in), .ENB(wrenl_in), .WEB(wel_in), .SSRB(1'b0), .ADDRB(wraddrl_in), .CLKB(wrclkl_in), .DOB(dangle_out32), .GSR(GSR), .DOPA(dop_wire), .DOPB(dangle_out4), .DIPA(4'b0), .DIPB(dip_in), .CASCADEOUTLATA(dangle_out), .CASCADEOUTLATB(dangle_out), .CASCADEOUTREGA(dangle_out), .CASCADEOUTREGB(dangle_out), .CASCADEINLATA(1'b0), .CASCADEINLATB(1'b0), .CASCADEINREGA(1'b0), .CASCADEINREGB(1'b0), .REGCEA(regcel_in), .REGCEB(1'b0), .REGCLKA(rdrclkl_in), .REGCLKB(1'b0), .DBITERR(dbiterr_wire), .ECCPARITY(eccparity_wire), .SBITERR(sbiterr_wire));

    defparam INT_RAMB.BRAM_MODE = BRAM_MODE;
    defparam INT_RAMB.INIT_A = INIT;
    defparam INT_RAMB.INIT_B = INIT;
    defparam INT_RAMB.INIT_FILE = INIT_FILE;
    defparam INT_RAMB.SRVAL_A = SRVAL;
    defparam INT_RAMB.SRVAL_B = SRVAL;
    defparam INT_RAMB.READ_WIDTH_A = 72;
    defparam INT_RAMB.READ_WIDTH_B = 72;
    defparam INT_RAMB.WRITE_WIDTH_A = 72;
    defparam INT_RAMB.WRITE_WIDTH_B = 72;
    defparam INT_RAMB.WRITE_MODE_A = "READ_FIRST";
    defparam INT_RAMB.WRITE_MODE_B = "READ_FIRST";
    defparam INT_RAMB.RAM_EXTENSION_A = "NONE";
    defparam INT_RAMB.RAM_EXTENSION_B = "NONE";
    defparam INT_RAMB.SETUP_ALL = SETUP_ALL;
    defparam INT_RAMB.SETUP_READ_FIRST = SETUP_READ_FIRST;
    defparam INT_RAMB.SIM_COLLISION_CHECK = SIM_COLLISION_CHECK;
    defparam INT_RAMB.EN_ECC_READ = EN_ECC_READ;
    defparam INT_RAMB.EN_ECC_SCRUB = EN_ECC_SCRUB;
    defparam INT_RAMB.EN_ECC_WRITE = EN_ECC_WRITE;
    defparam INT_RAMB.DOA_REG = DO_REG;
    defparam INT_RAMB.DOB_REG = DO_REG;
    defparam INT_RAMB.INIT_00 = INIT_00;
    defparam INT_RAMB.INIT_01 = INIT_01;
    defparam INT_RAMB.INIT_02 = INIT_02;
    defparam INT_RAMB.INIT_03 = INIT_03;
    defparam INT_RAMB.INIT_04 = INIT_04;
    defparam INT_RAMB.INIT_05 = INIT_05;
    defparam INT_RAMB.INIT_06 = INIT_06;
    defparam INT_RAMB.INIT_07 = INIT_07;
    defparam INT_RAMB.INIT_08 = INIT_08;
    defparam INT_RAMB.INIT_09 = INIT_09;
    defparam INT_RAMB.INIT_0A = INIT_0A;
    defparam INT_RAMB.INIT_0B = INIT_0B;
    defparam INT_RAMB.INIT_0C = INIT_0C;
    defparam INT_RAMB.INIT_0D = INIT_0D;
    defparam INT_RAMB.INIT_0E = INIT_0E;
    defparam INT_RAMB.INIT_0F = INIT_0F;
    defparam INT_RAMB.INIT_10 = INIT_10;
    defparam INT_RAMB.INIT_11 = INIT_11;
    defparam INT_RAMB.INIT_12 = INIT_12;
    defparam INT_RAMB.INIT_13 = INIT_13;
    defparam INT_RAMB.INIT_14 = INIT_14;
    defparam INT_RAMB.INIT_15 = INIT_15;
    defparam INT_RAMB.INIT_16 = INIT_16;
    defparam INT_RAMB.INIT_17 = INIT_17;
    defparam INT_RAMB.INIT_18 = INIT_18;
    defparam INT_RAMB.INIT_19 = INIT_19;
    defparam INT_RAMB.INIT_1A = INIT_1A;
    defparam INT_RAMB.INIT_1B = INIT_1B;
    defparam INT_RAMB.INIT_1C = INIT_1C;
    defparam INT_RAMB.INIT_1D = INIT_1D;
    defparam INT_RAMB.INIT_1E = INIT_1E;
    defparam INT_RAMB.INIT_1F = INIT_1F;
    defparam INT_RAMB.INIT_20 = INIT_20;
    defparam INT_RAMB.INIT_21 = INIT_21;
    defparam INT_RAMB.INIT_22 = INIT_22;
    defparam INT_RAMB.INIT_23 = INIT_23;
    defparam INT_RAMB.INIT_24 = INIT_24;
    defparam INT_RAMB.INIT_25 = INIT_25;
    defparam INT_RAMB.INIT_26 = INIT_26;
    defparam INT_RAMB.INIT_27 = INIT_27;
    defparam INT_RAMB.INIT_28 = INIT_28;
    defparam INT_RAMB.INIT_29 = INIT_29;
    defparam INT_RAMB.INIT_2A = INIT_2A;
    defparam INT_RAMB.INIT_2B = INIT_2B;
    defparam INT_RAMB.INIT_2C = INIT_2C;
    defparam INT_RAMB.INIT_2D = INIT_2D;
    defparam INT_RAMB.INIT_2E = INIT_2E;
    defparam INT_RAMB.INIT_2F = INIT_2F;
    defparam INT_RAMB.INIT_30 = INIT_30;
    defparam INT_RAMB.INIT_31 = INIT_31;
    defparam INT_RAMB.INIT_32 = INIT_32;
    defparam INT_RAMB.INIT_33 = INIT_33;
    defparam INT_RAMB.INIT_34 = INIT_34;
    defparam INT_RAMB.INIT_35 = INIT_35;
    defparam INT_RAMB.INIT_36 = INIT_36;
    defparam INT_RAMB.INIT_37 = INIT_37;
    defparam INT_RAMB.INIT_38 = INIT_38;
    defparam INT_RAMB.INIT_39 = INIT_39;
    defparam INT_RAMB.INIT_3A = INIT_3A;
    defparam INT_RAMB.INIT_3B = INIT_3B;
    defparam INT_RAMB.INIT_3C = INIT_3C;
    defparam INT_RAMB.INIT_3D = INIT_3D;
    defparam INT_RAMB.INIT_3E = INIT_3E;
    defparam INT_RAMB.INIT_3F = INIT_3F;
    defparam INT_RAMB.INIT_40 = INIT_40;
    defparam INT_RAMB.INIT_41 = INIT_41;
    defparam INT_RAMB.INIT_42 = INIT_42;
    defparam INT_RAMB.INIT_43 = INIT_43;
    defparam INT_RAMB.INIT_44 = INIT_44;
    defparam INT_RAMB.INIT_45 = INIT_45;
    defparam INT_RAMB.INIT_46 = INIT_46;
    defparam INT_RAMB.INIT_47 = INIT_47;
    defparam INT_RAMB.INIT_48 = INIT_48;
    defparam INT_RAMB.INIT_49 = INIT_49;
    defparam INT_RAMB.INIT_4A = INIT_4A;
    defparam INT_RAMB.INIT_4B = INIT_4B;
    defparam INT_RAMB.INIT_4C = INIT_4C;
    defparam INT_RAMB.INIT_4D = INIT_4D;
    defparam INT_RAMB.INIT_4E = INIT_4E;
    defparam INT_RAMB.INIT_4F = INIT_4F;
    defparam INT_RAMB.INIT_50 = INIT_50;
    defparam INT_RAMB.INIT_51 = INIT_51;
    defparam INT_RAMB.INIT_52 = INIT_52;
    defparam INT_RAMB.INIT_53 = INIT_53;
    defparam INT_RAMB.INIT_54 = INIT_54;
    defparam INT_RAMB.INIT_55 = INIT_55;
    defparam INT_RAMB.INIT_56 = INIT_56;
    defparam INT_RAMB.INIT_57 = INIT_57;
    defparam INT_RAMB.INIT_58 = INIT_58;
    defparam INT_RAMB.INIT_59 = INIT_59;
    defparam INT_RAMB.INIT_5A = INIT_5A;
    defparam INT_RAMB.INIT_5B = INIT_5B;
    defparam INT_RAMB.INIT_5C = INIT_5C;
    defparam INT_RAMB.INIT_5D = INIT_5D;
    defparam INT_RAMB.INIT_5E = INIT_5E;
    defparam INT_RAMB.INIT_5F = INIT_5F;
    defparam INT_RAMB.INIT_60 = INIT_60;
    defparam INT_RAMB.INIT_61 = INIT_61;
    defparam INT_RAMB.INIT_62 = INIT_62;
    defparam INT_RAMB.INIT_63 = INIT_63;
    defparam INT_RAMB.INIT_64 = INIT_64;
    defparam INT_RAMB.INIT_65 = INIT_65;
    defparam INT_RAMB.INIT_66 = INIT_66;
    defparam INT_RAMB.INIT_67 = INIT_67;
    defparam INT_RAMB.INIT_68 = INIT_68;
    defparam INT_RAMB.INIT_69 = INIT_69;
    defparam INT_RAMB.INIT_6A = INIT_6A;
    defparam INT_RAMB.INIT_6B = INIT_6B;
    defparam INT_RAMB.INIT_6C = INIT_6C;
    defparam INT_RAMB.INIT_6D = INIT_6D;
    defparam INT_RAMB.INIT_6E = INIT_6E;
    defparam INT_RAMB.INIT_6F = INIT_6F;
    defparam INT_RAMB.INIT_70 = INIT_70;
    defparam INT_RAMB.INIT_71 = INIT_71;
    defparam INT_RAMB.INIT_72 = INIT_72;
    defparam INT_RAMB.INIT_73 = INIT_73;
    defparam INT_RAMB.INIT_74 = INIT_74;
    defparam INT_RAMB.INIT_75 = INIT_75;
    defparam INT_RAMB.INIT_76 = INIT_76;
    defparam INT_RAMB.INIT_77 = INIT_77;
    defparam INT_RAMB.INIT_78 = INIT_78;
    defparam INT_RAMB.INIT_79 = INIT_79;
    defparam INT_RAMB.INIT_7A = INIT_7A;
    defparam INT_RAMB.INIT_7B = INIT_7B;
    defparam INT_RAMB.INIT_7C = INIT_7C;
    defparam INT_RAMB.INIT_7D = INIT_7D;
    defparam INT_RAMB.INIT_7E = INIT_7E;
    defparam INT_RAMB.INIT_7F = INIT_7F;
    defparam INT_RAMB.INITP_00 = INITP_00;
    defparam INT_RAMB.INITP_01 = INITP_01;
    defparam INT_RAMB.INITP_02 = INITP_02;
    defparam INT_RAMB.INITP_03 = INITP_03;
    defparam INT_RAMB.INITP_04 = INITP_04;
    defparam INT_RAMB.INITP_05 = INITP_05;
    defparam INT_RAMB.INITP_06 = INITP_06;
    defparam INT_RAMB.INITP_07 = INITP_07;
    defparam INT_RAMB.INITP_08 = INITP_08;
    defparam INT_RAMB.INITP_09 = INITP_09;
    defparam INT_RAMB.INITP_0A = INITP_0A;
    defparam INT_RAMB.INITP_0B = INITP_0B;
    defparam INT_RAMB.INITP_0C = INITP_0C;
    defparam INT_RAMB.INITP_0D = INITP_0D;
    defparam INT_RAMB.INITP_0E = INITP_0E;
    defparam INT_RAMB.INITP_0F = INITP_0F;


//*** Timing Checks Start here
    wire di0_enable = wrenl_in && wel_in[0];
    wire di1_enable = wrenl_in && wel_in[1];
    wire di2_enable = wrenl_in && wel_in[2];
    wire di3_enable = wrenl_in && wel_in[3];
    wire di4_enable = wrenl_in && wel_in[4];
    wire di5_enable = wrenl_in && wel_in[5];
    wire di6_enable = wrenl_in && wel_in[6];
    wire di7_enable = wrenl_in && wel_in[7];
    
    always @(notifier or notifier_addr0 or notifier_addr1 or notifier_addr2 or notifier_addr3 or notifier_addr4 or
             notifier_addr5 or notifier_addr6 or notifier_addr7 or notifier_addr8 or notifier_addr9 or notifier_addr10 or 
             notifier_addr11 or notifier_addr12 or notifier_addr13 or notifier_addr14 or notifier_addr15) begin    
	do_out <= 64'hxxxxxxxxxxxxxxxx;
	dop_out <= 8'hxx;
	dbiterr_out <= 1'bx;
	sbiterr_out <= 1'bx;
	eccparity_out <= 8'hxx;
    end

    
    always @(notifier_addr0) begin
	task_warn_msg ("WRADDRL[0]", "WRCLKL");
    end

    always @(notifier_addr1) begin
	task_warn_msg ("WRADDRL[1]", "WRCLKL");
    end
    
    always @(notifier_addr2) begin
	task_warn_msg ("WRADDRL[2]", "WRCLKL");
    end
    
    always @(notifier_addr3) begin
	task_warn_msg ("WRADDRL[3]", "WRCLKL");
    end
    
    always @(notifier_addr4) begin
	task_warn_msg ("WRADDRL[4]", "WRCLKL");
    end

    always @(notifier_addr5) begin
	task_warn_msg ("WRADDRL[5]", "WRCLKL");
    end
    
    always @(notifier_addr6) begin
	task_warn_msg ("WRADDRL[6]", "WRCLKL");
    end
    
    always @(notifier_addr7) begin
	task_warn_msg ("WRADDRL[7]", "WRCLKL");
    end   

    always @(notifier_addr8) begin
	task_warn_msg ("WRADDRL[8]", "WRCLKL");
    end

    always @(notifier_addr9) begin
	task_warn_msg ("WRADDRL[9]", "WRCLKL");
    end
    
    always @(notifier_addr10) begin
	task_warn_msg ("WRADDRL[10]", "WRCLKL");
    end
    
    always @(notifier_addr11) begin
	task_warn_msg ("WRADDRL[11]", "WRCLKL");
    end
    
    always @(notifier_addr12) begin
	task_warn_msg ("WRADDRL[12]", "WRCLKL");
    end

    always @(notifier_addr13) begin
	task_warn_msg ("WRADDRL[13]", "WRCLKL");
    end
    
    always @(notifier_addr14) begin
	task_warn_msg ("WRADDRL[14]", "WRCLKL");
    end
    
    always @(notifier_addr15) begin
	task_warn_msg ("WRADDRL[15]", "WRCLKL");
    end

    
    task task_warn_msg;

        input [8*11:1] addr_str;
	input [8*6:1] clk_str;
	
	begin

	    $display("Error: Setup/Hold Violation on %s with respect to %s when memory has been enabled. The memory contents at %s of the RAM can be corrupted. This corruption is not modeled in this simulation model. Please take the necessary steps to recover from this data corruption in hardware.", addr_str, clk_str, addr_str);

	end
	
    endtask // task_warn_msg
    
    
    specify

        (RDCLKL => DO[0]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[1]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[2]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[3]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[4]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[5]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[6]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[7]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[8]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[9]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[10]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[11]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[12]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[13]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[14]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[15]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[16]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[17]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[18]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[19]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[20]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[21]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[22]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[23]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[24]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[25]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[26]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[27]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[28]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[29]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[30]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[31]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[32]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[33]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[34]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[35]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[36]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[37]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[38]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[39]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[40]) = (100:100:100, 100:100:100);
	(RDCLKL => DO[41]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[42]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[43]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[44]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[45]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[46]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[47]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[48]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[49]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[50]) = (100:100:100, 100:100:100);
	(RDCLKL => DO[51]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[52]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[53]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[54]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[55]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[56]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[57]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[58]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[59]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[60]) = (100:100:100, 100:100:100);
	(RDCLKL => DO[61]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[62]) = (100:100:100, 100:100:100);
        (RDCLKL => DO[63]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[0]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[1]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[2]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[3]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[4]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[5]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[6]) = (100:100:100, 100:100:100);
        (RDCLKL => DOP[7]) = (100:100:100, 100:100:100);
	(RDCLKL => DBITERR) = (100:100:100, 100:100:100);
	(RDCLKL => SBITERR) = (100:100:100, 100:100:100);

	(RDRCLKL => DO[0]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[1]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[2]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[3]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[4]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[5]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[6]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[7]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[8]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[9]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[10]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[11]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[12]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[13]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[14]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[15]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[16]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[17]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[18]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[19]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[20]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[21]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[22]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[23]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[24]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[25]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[26]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[27]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[28]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[29]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[30]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[31]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[32]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[33]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[34]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[35]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[36]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[37]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[38]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[39]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[40]) = (100:100:100, 100:100:100);
	(RDRCLKL => DO[41]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[42]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[43]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[44]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[45]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[46]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[47]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[48]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[49]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[50]) = (100:100:100, 100:100:100);
	(RDRCLKL => DO[51]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[52]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[53]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[54]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[55]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[56]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[57]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[58]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[59]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[60]) = (100:100:100, 100:100:100);
	(RDRCLKL => DO[61]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[62]) = (100:100:100, 100:100:100);
        (RDRCLKL => DO[63]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[0]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[1]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[2]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[3]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[4]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[5]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[6]) = (100:100:100, 100:100:100);
        (RDRCLKL => DOP[7]) = (100:100:100, 100:100:100);
	(RDRCLKL => DBITERR) = (100:100:100, 100:100:100);
	(RDRCLKL => SBITERR) = (100:100:100, 100:100:100);
	
        (WRCLKL => ECCPARITY[0]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[1]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[2]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[3]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[4]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[5]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[6]) = (100:100:100, 100:100:100);
        (WRCLKL => ECCPARITY[7]) = (100:100:100, 100:100:100);
	
       	$setuphold (posedge WRCLKL, posedge WRADDRL[0] &&& WRENL, 0:0:0, 0:0:0, notifier_addr0);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[0] &&& WRENL, 0:0:0, 0:0:0, notifier_addr0);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[1] &&& WRENL, 0:0:0, 0:0:0, notifier_addr1);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[1] &&& WRENL, 0:0:0, 0:0:0, notifier_addr1);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[2] &&& WRENL, 0:0:0, 0:0:0, notifier_addr2);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[2] &&& WRENL, 0:0:0, 0:0:0, notifier_addr2);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[3] &&& WRENL, 0:0:0, 0:0:0, notifier_addr3);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[3] &&& WRENL, 0:0:0, 0:0:0, notifier_addr3);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[4] &&& WRENL, 0:0:0, 0:0:0, notifier_addr4);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[4] &&& WRENL, 0:0:0, 0:0:0, notifier_addr4);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[5] &&& WRENL, 0:0:0, 0:0:0, notifier_addr5);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[5] &&& WRENL, 0:0:0, 0:0:0, notifier_addr5);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[6] &&& WRENL, 0:0:0, 0:0:0, notifier_addr6);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[6] &&& WRENL, 0:0:0, 0:0:0, notifier_addr6);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[7] &&& WRENL, 0:0:0, 0:0:0, notifier_addr7);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[7] &&& WRENL, 0:0:0, 0:0:0, notifier_addr7);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[8] &&& WRENL, 0:0:0, 0:0:0, notifier_addr8);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[8] &&& WRENL, 0:0:0, 0:0:0, notifier_addr8);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[9] &&& WRENL, 0:0:0, 0:0:0, notifier_addr9);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[9] &&& WRENL, 0:0:0, 0:0:0, notifier_addr9);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[10] &&& WRENL, 0:0:0, 0:0:0, notifier_addr10);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[10] &&& WRENL, 0:0:0, 0:0:0, notifier_addr10);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[11] &&& WRENL, 0:0:0, 0:0:0, notifier_addr11);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[11] &&& WRENL, 0:0:0, 0:0:0, notifier_addr11);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[12] &&& WRENL, 0:0:0, 0:0:0, notifier_addr12);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[12] &&& WRENL, 0:0:0, 0:0:0, notifier_addr12);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[13] &&& WRENL, 0:0:0, 0:0:0, notifier_addr13);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[13] &&& WRENL, 0:0:0, 0:0:0, notifier_addr13);
       	$setuphold (posedge WRCLKL, posedge WRADDRL[14] &&& WRENL, 0:0:0, 0:0:0, notifier_addr14);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[14] &&& WRENL, 0:0:0, 0:0:0, notifier_addr14);
	$setuphold (posedge WRCLKL, posedge WRADDRL[15] &&& WRENL, 0:0:0, 0:0:0, notifier_addr15);
       	$setuphold (posedge WRCLKL, negedge WRADDRL[15] &&& WRENL, 0:0:0, 0:0:0, notifier_addr15);

	$setuphold (posedge RDCLKL, posedge RDADDRL[0] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[0] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[1] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[1] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[2] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[2] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[3] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[3] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[4] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[4] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[5] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[5] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[6] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[6] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[7] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[7] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[8] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[8] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[9] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[9] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[10] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[10] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[11] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[11] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[12] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[12] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[13] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[13] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDADDRL[14] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[14] &&& RDENL, 0:0:0, 0:0:0, notifier);
	$setuphold (posedge RDCLKL, posedge RDADDRL[15] &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDADDRL[15] &&& RDENL, 0:0:0, 0:0:0, notifier);
	
       	$setuphold (posedge WRCLKL, posedge DI[0] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[0] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[1] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[1] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[2] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[2] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[3] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[3] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[4] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[4] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[5] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[5] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[6] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[6] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[7] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[7] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[8] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[8] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[9] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[9] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[10] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[10] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[11] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[11] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[12] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[12] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[13] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[13] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[14] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[14] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[15] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[15] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[16] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[16] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[17] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[17] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[18] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[18] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[19] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[19] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[20] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[20] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[21] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[21] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[22] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[22] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[23] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[23] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[24] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[24] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[25] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[25] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[26] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[26] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[27] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[27] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[28] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[28] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[29] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[29] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[30] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[30] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[31] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[31] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[32] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[32] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[33] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[33] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[34] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[34] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[35] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[35] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[36] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[36] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[37] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[37] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[38] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[38] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[39] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[39] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[40] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[40] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[41] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[41] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[42] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[42] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[43] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[43] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[44] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[44] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[45] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[45] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[46] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[46] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[47] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[47] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[48] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[48] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[49] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[49] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[50] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[50] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[51] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[51] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[52] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[52] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[53] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[53] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[54] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[54] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[55] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[55] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[56] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[56] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[57] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[57] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[58] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[58] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[59] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[59] &&& di7_enable, 0:0:0, 0:0:0, notifier);
	$setuphold (posedge WRCLKL, posedge DI[60] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[60] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[61] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[61] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[62] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[62] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DI[63] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DI[63] &&& di7_enable, 0:0:0, 0:0:0, notifier);
	
       	$setuphold (posedge WRCLKL, posedge DIP[0] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[0] &&& di0_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[1] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[1] &&& di1_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[2] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[2] &&& di2_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[3] &&& di3_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[3] &&& di3_enable, 0:0:0, 0:0:0, notifier);
	$setuphold (posedge WRCLKL, posedge DIP[4] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[4] &&& di4_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[5] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[5] &&& di5_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[6] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[6] &&& di6_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge DIP[7] &&& di7_enable, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge DIP[7] &&& di7_enable, 0:0:0, 0:0:0, notifier);
	
       	$setuphold (posedge WRCLKL, posedge WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge SSRL &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge SSRL &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, posedge SSRL &&& RDENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDCLKL, negedge SSRL &&& RDENL, 0:0:0, 0:0:0, notifier);

       	$setuphold (posedge RDRCLKL, posedge REGCEL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDRCLKL, negedge REGCEL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDRCLKL, posedge SSRL &&& REGCEL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge RDRCLKL, negedge SSRL &&& REGCEL, 0:0:0, 0:0:0, notifier);
	
       	$setuphold (posedge WRCLKL, posedge WEL[0] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[0] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[1] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[1] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[2] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[2] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[3] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[3] &&& WRENL, 0:0:0, 0:0:0, notifier);
	$setuphold (posedge WRCLKL, posedge WEL[4] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[4] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[5] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[5] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[6] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[6] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, posedge WEL[7] &&& WRENL, 0:0:0, 0:0:0, notifier);
       	$setuphold (posedge WRCLKL, negedge WEL[7] &&& WRENL, 0:0:0, 0:0:0, notifier);

	$period (posedge WRCLKL, 0:0:0, notifier);
	$period (posedge RDCLKL, 0:0:0, notifier);
	$period (posedge RDRCLKL, 0:0:0, notifier);

        $width (posedge RDCLKL &&& RDENL, 0:0:0, 0, notifier);
        $width (negedge RDCLKL &&& RDENL, 0:0:0, 0, notifier);
	$width (posedge RDRCLKL &&& REGCEL, 0:0:0, 0, notifier);
        $width (negedge RDRCLKL &&& REGCEL, 0:0:0, 0, notifier);
        $width (posedge WRCLKL &&& WRENL, 0:0:0, 0, notifier);
        $width (negedge WRCLKL &&& WRENL, 0:0:0, 0, notifier);

	specparam PATHPULSE$ = 0;

    endspecify

endmodule // X_RAMB36SDP_EXP



    

